<?php
namespace CortexMikado\Modules\Shortcodes\Lib;

use CortexMikado\Modules\Shortcodes\Accordion\Accordion;
use CortexMikado\Modules\Shortcodes\AccordionTab\AccordionTab;
use CortexMikado\Modules\Shortcodes\Blockquote\Blockquote;
use CortexMikado\Modules\Shortcodes\BlogList\BlogList;
use CortexMikado\Modules\Shortcodes\BlogSlider\BlogSlider;
use CortexMikado\Modules\Shortcodes\Button\Button;
use CortexMikado\Modules\Shortcodes\CallToAction\CallToAction;
use CortexMikado\Modules\Shortcodes\Counter\Countdown;
use CortexMikado\Modules\Shortcodes\Counter\Counter;
use CortexMikado\Modules\Shortcodes\CustomFont\CustomFont;
use CortexMikado\Modules\Shortcodes\Dropcaps\Dropcaps;
use CortexMikado\Modules\Shortcodes\ElementsHolder\ElementsHolder;
use CortexMikado\Modules\Shortcodes\ElementsHolderItem\ElementsHolderItem;
use CortexMikado\Modules\Shortcodes\GoogleMap\GoogleMap;
use CortexMikado\Modules\Shortcodes\Highlight\Highlight;
use CortexMikado\Modules\Shortcodes\Icon\Icon;
use CortexMikado\Modules\Shortcodes\IconListItem\IconListItem;
use CortexMikado\Modules\Shortcodes\IconWithText\IconWithText;
use CortexMikado\Modules\Shortcodes\ImageGallery\ImageGallery;
use CortexMikado\Modules\Shortcodes\Message\Message;
use CortexMikado\Modules\Shortcodes\OrderedList\OrderedList;
use CortexMikado\Modules\Shortcodes\PieCharts\PieChartBasic\PieChartBasic;
use CortexMikado\Modules\Shortcodes\PieCharts\PieChartDoughnut\PieChartDoughnut;
use CortexMikado\Modules\Shortcodes\PieCharts\PieChartDoughnut\PieChartPie;
use CortexMikado\Modules\Shortcodes\PieCharts\PieChartWithIcon\PieChartWithIcon;
use CortexMikado\Modules\Shortcodes\PricingTables\PricingTables;
use CortexMikado\Modules\Shortcodes\PricingTable\PricingTable;
use CortexMikado\Modules\Shortcodes\Process\ProcessHolder;
use CortexMikado\Modules\Shortcodes\Process\ProcessItem;
use CortexMikado\Modules\Shortcodes\ProgressBar\ProgressBar;
use CortexMikado\Modules\Shortcodes\Separator\Separator;
use CortexMikado\Modules\Shortcodes\SocialShare\SocialShare;
use CortexMikado\Modules\Shortcodes\Tabs\Tabs;
use CortexMikado\Modules\Shortcodes\Tab\Tab;
use CortexMikado\Modules\Shortcodes\Team\Team;
use CortexMikado\Modules\Shortcodes\UnorderedList\UnorderedList;
use CortexMikado\Modules\Shortcodes\VerticalSplitSlider\VerticalSplitSlider;
use CortexMikado\Modules\Shortcodes\VerticalSplitSliderContentItem\VerticalSplitSliderContentItem;
use CortexMikado\Modules\Shortcodes\VerticalSplitSliderLeftPanel\VerticalSplitSliderLeftPanel;
use CortexMikado\Modules\Shortcodes\VerticalSplitSliderRightPanel\VerticalSplitSliderRightPanel;
use CortexMikado\Modules\Shortcodes\VideoButton\VideoButton;
use CortexMikado\Modules\Shortcodes\Clients\Clients;
use CortexMikado\Modules\Shortcodes\Client\Client;
use CortexMikado\Modules\Shortcodes\SectionSubtitle\SectionSubtitle;
use CortexMikado\Modules\Shortcodes\SectionTitle\SectionTitle;
use CortexMikado\Modules\Shortcodes\SectionHolder\SectionHolder;
use CortexMikado\Modules\Shortcodes\SectionItem\SectionItem;
use CortexMikado\Modules\Shortcodes\ImageWithText\ImageWithText;
use CortexMikado\Modules\Shortcodes\TextSlider\TextSlider;
use CortexMikado\Modules\Shortcodes\TextSliderItem\TextSliderItem;
use CortexMikado\Modules\Shortcodes\InteractiveItems\InteractiveItems;
use CortexMikado\Modules\Shortcodes\InteractiveItem\InteractiveItem;
use CortexMikado\Modules\Shortcodes\Banner\Banner;
use CortexMikado\Modules\Shortcodes\ParallaxCallToAction\ParallaxCallToAction;

/**
 * Class ShortcodeLoader
 */
class ShortcodeLoader {
    /**
     * @var private instance of current class
     */
    private static $instance;
    /**
     * @var array
     */
    private $loadedShortcodes = array();

    /**
     * Private constuct because of Singletone
     */
    private function __construct() {}

    /**
     * Private sleep because of Singletone
     */
    private function __wakeup() {}

    /**
     * Private clone because of Singletone
     */
    private function __clone() {}

    /**
     * Returns current instance of class
     * @return ShortcodeLoader
     */
    public static function getInstance() {
        if(self::$instance == null) {
            return new self;
        }

        return self::$instance;
    }

    /**
     * Adds new shortcode. Object that it takes must implement ShortcodeInterface
     * @param ShortcodeInterface $shortcode
     */
    private function addShortcode(ShortcodeInterface $shortcode) {
        if(!array_key_exists($shortcode->getBase(), $this->loadedShortcodes)) {
            $this->loadedShortcodes[$shortcode->getBase()] = $shortcode;
        }
    }

    /**
     * Adds all shortcodes.
     *
     * @see ShortcodeLoader::addShortcode()
     */
    private function addShortcodes() {
        $this->addShortcode(new Accordion());
        $this->addShortcode(new AccordionTab());
        $this->addShortcode(new Blockquote());
        $this->addShortcode(new BlogList());
        $this->addShortcode(new BlogSlider());
        $this->addShortcode(new Button());
        $this->addShortcode(new CallToAction());
        $this->addShortcode(new Counter());
        $this->addShortcode(new Countdown());
        $this->addShortcode(new CustomFont());
        $this->addShortcode(new Dropcaps());
        $this->addShortcode(new ElementsHolder());
        $this->addShortcode(new ElementsHolderItem());
        $this->addShortcode(new GoogleMap());
        $this->addShortcode(new Highlight());
        $this->addShortcode(new Icon());
        $this->addShortcode(new IconListItem());
        $this->addShortcode(new IconWithText());
        $this->addShortcode(new ImageGallery());
        $this->addShortcode(new Message());
        $this->addShortcode(new OrderedList());
        $this->addShortcode(new PieChartBasic());
        $this->addShortcode(new PieChartPie());
        $this->addShortcode(new PieChartDoughnut());
        $this->addShortcode(new PieChartWithIcon());
        $this->addShortcode(new PricingTables());
        $this->addShortcode(new PricingTable());
        $this->addShortcode(new ProgressBar());
        $this->addShortcode(new ProcessHolder());
        $this->addShortcode(new ProcessItem());
        $this->addShortcode(new Separator());
        $this->addShortcode(new SocialShare());
        $this->addShortcode(new Tabs());
        $this->addShortcode(new Tab());
        $this->addShortcode(new Team());
        $this->addShortcode(new UnorderedList());
        $this->addShortcode(new VideoButton());
        $this->addShortcode(new VerticalSplitSlider());
        $this->addShortcode(new VerticalSplitSliderLeftPanel());
        $this->addShortcode(new VerticalSplitSliderRightPanel());
        $this->addShortcode(new VerticalSplitSliderContentItem());
        $this->addShortcode(new Clients());
        $this->addShortcode(new Client());
        $this->addShortcode(new SectionSubtitle());
        $this->addShortcode(new SectionTitle());
        $this->addShortcode(new SectionHolder());
        $this->addShortcode(new SectionItem());
        $this->addShortcode(new ImageWithText());
        $this->addShortcode(new TextSlider());
        $this->addShortcode(new TextSliderItem());
        $this->addShortcode(new InteractiveItems());
        $this->addShortcode(new InteractiveItem());
        $this->addShortcode(new Banner());
        $this->addShortcode(new ParallaxCallToAction());
    }
    /**
     * Calls ShortcodeLoader::addShortcodes and than loops through added shortcodes and calls render method
     * of each shortcode object
     */
    public function load() {
        $this->addShortcodes();

        foreach ($this->loadedShortcodes as $shortcode) {
            add_shortcode($shortcode->getBase(), array($shortcode, 'render'));
        }
    }
}

$shortcodeLoader = ShortcodeLoader::getInstance();
$shortcodeLoader->load();