<?php
namespace MikadoCore\PostTypes\Testimonials;

use MikadoCore\Lib;


/**
 * Class TestimonialsRegister
 * @package MikadoCore\PostTypes\Testimonials
 */
class TestimonialsRegister implements Lib\PostTypeInterface {
    /**
     * @var string
     */
    private $base;

    public function __construct() {
        $this->base		= 'testimonials';
        $this->taxBase	= 'testimonials_category';
    }

    /**
     * @return string
     */
    public function getBase() {
        return $this->base;
    }

    /**
     * Registers custom post type with WordPress
     */
    public function register() {
        $this->registerPostType();
        $this->registerTax();
    }

    /**
     * Regsiters custom post type with WordPress
     */
    private function registerPostType() {
        global $cortex_mikado_Framework;

        $menuPosition = 5;
        $menuIcon = 'dashicons-admin-post';

        if(mkd_core_theme_installed()) {
            $menuPosition = $cortex_mikado_Framework->getSkin()->getMenuItemPosition('testimonial');
            $menuIcon = $cortex_mikado_Framework->getSkin()->getMenuIcon('testimonial');
        }

        register_post_type('testimonials',
            array(
                'labels' 		=> array(
                    'name' 				=> esc_html__('Testimonials','mikado-cpt' ),
                    'singular_name' 	=> esc_html__('Testimonial','mikado-cpt' ),
                    'add_item'			=> esc_html__('New Testimonial','mikado-cpt'),
                    'add_new_item' 		=> esc_html__('Add New Testimonial','mikado-cpt'),
                    'edit_item' 		=> esc_html__('Edit Testimonial','mikado-cpt')
                ),
                'public'		=>	false,
                'show_in_menu'	=>	true,
                'rewrite' 		=> 	array('slug' => 'testimonials'),
                'menu_position' => 	$menuPosition,
                'show_ui'		=>	true,
                'has_archive'	=>	false,
                'hierarchical'	=>	false,
                'supports'		=>	array('title', 'thumbnail'),
                'menu_icon'  	=>  $menuIcon
            )
        );
    }

    /**
     * Registers custom taxonomy with WordPress
     */
    private function registerTax() {
        $labels = array(
            'name'				=> esc_html__( 'Testimonials Categories', 'mikado-cpt' ),
            'singular_name'		=> esc_html__( 'Testimonial Category', 'mikado-cpt' ),
            'search_items'		=> esc_html__( 'Search Testimonials Categories', 'mikado-cpt' ),
            'all_items'			=> esc_html__( 'All Testimonials Categories', 'mikado-cpt' ),
            'parent_item'		=> esc_html__( 'Parent Testimonial Category', 'mikado-cpt' ),
            'parent_item_colon'	=> esc_html__( 'Parent Testimonial Category:', 'mikado-cpt' ),
            'edit_item'			=> esc_html__( 'Edit Testimonials Category', 'mikado-cpt' ),
            'update_item'		=> esc_html__( 'Update Testimonials Category', 'mikado-cpt' ),
            'add_new_item'		=> esc_html__( 'Add New Testimonials Category', 'mikado-cpt' ),
            'new_item_name'		=> esc_html__( 'New Testimonials Category Name', 'mikado-cpt' ),
            'menu_name'			=> esc_html__( 'Testimonials Categories', 'mikado-cpt' ),
        );

        register_taxonomy($this->taxBase, array($this->base), array(
            'hierarchical'		=> true,
            'labels'			=> $labels,
            'show_ui'			=> true,
            'query_var'			=> true,
            'show_admin_column' => true,
            'rewrite'			=> array( 'slug' => 'testimonials-category' ),
        ));
    }

}