<?php

if ( ! function_exists( 'cortex_core_load_widget_class' ) ) {
    /**
     * Loades widget class file.
     */
    function cortex_core_load_widget_class() {
        include_once 'widget-class.php';
    }

    add_action( 'cortex_mikado_before_options_map', 'cortex_core_load_widget_class' );
}

if ( ! function_exists( 'cortex_core_load_widgets' ) ) {
    /**
     * Loades all widgets by going through all folders that are placed directly in widgets folder
     * and loads load.php file in each. Hooks to cortex_elated_before_options_map_map action
     */
    function cortex_core_load_widgets() {

        if ( cortex_mikado_core_installed() ) {
            foreach ( glob( MIKADO_FRAMEWORK_ROOT_DIR . '/modules/widgets/*/load.php' ) as $widget_load ) {
                include_once $widget_load;
            }
        }

        include_once 'widget-loader.php';
    }

    add_action( 'cortex_mikado_before_options_map', 'cortex_core_load_widgets' );
}