<?php
namespace MikadoCore\PostTypes\Carousels;

use MikadoCore\Lib;

/**
 * Class CarouselRegister
 * @package MikadoCore\PostTypes\Carousels
 */
class CarouselRegister implements Lib\PostTypeInterface {
    /**
     * @var string
     */
    private $base;
    /**
     * @var string
     */
    private $taxBase;

    public function __construct() {
        $this->base		= 'carousels';
        $this->taxBase	= 'carousels_category';
    }

    /**
     * @return string
     */
    public function getBase() {
        return $this->base;
    }

    /**
     * Registers custom post type with WordPress
     */
    public function register() {
        $this->registerPostType();
        $this->registerTax();
    }

    /**
     * Registers custom post type with WordPress
     */
    private function registerPostType() {
        global $cortex_mikado_Framework;

        $menuPosition = 5;
        $menuIcon = 'dashicons-admin-post';
        if(mkd_core_theme_installed()) {
            $menuPosition = $cortex_mikado_Framework->getSkin()->getMenuItemPosition('carousel');
            $menuIcon = $cortex_mikado_Framework->getSkin()->getMenuIcon('carousel');
        }

        register_post_type($this->base,
            array(
                'labels'    => array(
                    'name'			=> esc_html__('Mikado Carousel', 'mikado-cpt' ),
                    'menu_name'		=> esc_html__('Mikado Carousel', 'mikado-cpt' ),
                    'all_items'		=> esc_html__('Carousel Items', 'mikado-cpt' ),
                    'add_new'		=> esc_html__('Add New Carousel Item', 'mikado-cpt'),
                    'singular_name'	=> esc_html__('Carousel Item', 'mikado-cpt' ),
                    'add_item'		=> esc_html__('New Carousel Item', 'mikado-cpt'),
                    'add_new_item' 	=> esc_html__('Add New Carousel Item', 'mikado-cpt'),
                    'edit_item'		=> esc_html__('Edit Carousel Item', 'mikado-cpt')
                ),
                'public'		=>  false,
                'show_in_menu'	=>  true,
                'rewrite'		=>  array('slug' => 'carousels'),
                'menu_position'	=>  $menuPosition,
                'show_ui'		=>  true,
                'has_archive'	=>  false,
                'hierarchical'	=>  false,
                'supports'		=>  array('title'),
                'menu_icon'		=>  $menuIcon
            )
        );
    }

    /**
     * Registers custom taxonomy with WordPress
     */
    private function registerTax() {
        $labels = array(
            'name'				=> esc_html__( 'Carousels', 'mikado-cpt' ),
            'singular_name'		=> esc_html__( 'Carousel', 'mikado-cpt' ),
            'search_items'		=> esc_html__( 'Search Carousels', 'mikado-cpt' ),
            'all_items'			=> esc_html__( 'All Carousels', 'mikado-cpt' ),
            'parent_item'		=> esc_html__( 'Parent Carousel', 'mikado-cpt' ),
            'parent_item_colon'	=> esc_html__( 'Parent Carousel:', 'mikado-cpt' ),
            'edit_item'			=> esc_html__( 'Edit Carousel', 'mikado-cpt' ),
            'update_item'		=> esc_html__( 'Update Carousel', 'mikado-cpt' ),
            'add_new_item'		=> esc_html__( 'Add New Carousel', 'mikado-cpt' ),
            'new_item_name'		=> esc_html__( 'New Carousel Name', 'mikado-cpt' ),
            'menu_name'			=> esc_html__( 'Carousels', 'mikado-cpt' ),
        );

        register_taxonomy($this->taxBase, array($this->base), array(
            'hierarchical'		=> true,
            'labels'			=> $labels,
            'show_ui'			=> true,
            'query_var'			=> true,
            'show_admin_column' => true,
            'rewrite'			=> array( 'slug' => 'carousels-category' ),
        ));
    }

}