<?php
namespace MikadoCore\PostTypes\Slider;

use MikadoCore\Lib;

/**
 * Class SliderRegister
 * @package MikadoCore\PostTypes\Slider
 */
class SliderRegister implements Lib\PostTypeInterface {
    /**
     * @var string
     */
    private $base;

    public function __construct() {
        $this->base		= 'slides';
        $this->taxBase	= 'slides_category';
    }

    /**
     * @return string
     */
    public function getBase() {
        return $this->base;
    }

    /**
     * Registers custom post type with WordPress
     */
    public function register() {
        $this->registerPostType();
        $this->registerTax();
    }

    /**
     * Registers custom post type with WordPress
     */
    private function registerPostType() {
        global $cortex_mikado_Framework;

        $menuPosition = 5;
        $menuIcon = 'dashicons-admin-post';

        if(mkd_core_theme_installed()) {
            $menuPosition = $cortex_mikado_Framework->getSkin()->getMenuItemPosition('slider');
            $menuIcon = $cortex_mikado_Framework->getSkin()->getMenuIcon('slider');
        }

        register_post_type($this->base,
            array(
                'labels' 		=> array(
                    'name'			=> esc_html__( 'Mikado Slider', 'mikado-cpt' ),
                    'menu_name'		=> esc_html__( 'Mikado Slider', 'mikado-cpt' ),
                    'all_items'		=> esc_html__( 'Slides', 'mikado-cpt' ),
                    'add_new'		=> esc_html__( 'Add New Slide', 'mikado-cpt' ),
                    'singular_name'	=> esc_html__( 'Slide', 'mikado-cpt' ),
                    'add_item'		=> esc_html__( 'New Slide', 'mikado-cpt' ),
                    'add_new_item'	=> esc_html__( 'Add New Slide', 'mikado-cpt' ),
                    'edit_item'		=> esc_html__( 'Edit Slide', 'mikado-cpt' )
                ),
                'public'		=>	false,
                'show_in_menu'	=>	true,
                'rewrite' 		=> 	array('slug' => 'slides'),
                'menu_position' => 	$menuPosition,
                'show_ui'		=>	true,
                'has_archive'	=>	false,
                'hierarchical'	=>	false,
                'supports'		=>	array('title', 'thumbnail', 'page-attributes'),
                'menu_icon'		=>  $menuIcon
            )
        );
    }

    /**
     * Registers custom taxonomy with WordPress
     */
    private function registerTax() {
        $labels = array(
            'name'				=> esc_html__( 'Sliders', 'mikado-cpt' ),
            'singular_name'		=> esc_html__( 'Slider', 'mikado-cpt' ),
            'search_items'		=> esc_html__( 'Search Sliders', 'mikado-cpt' ),
            'all_items'			=> esc_html__( 'All Sliders', 'mikado-cpt' ),
            'parent_item'		=> esc_html__( 'Parent Slider', 'mikado-cpt' ),
            'parent_item_colon'	=> esc_html__( 'Parent Slider:', 'mikado-cpt' ),
            'edit_item'			=> esc_html__( 'Edit Slider', 'mikado-cpt' ),
            'update_item'		=> esc_html__( 'Update Slider', 'mikado-cpt' ),
            'add_new_item'		=> esc_html__( 'Add New Slider', 'mikado-cpt' ),
            'new_item_name'		=> esc_html__( 'New Slider Name', 'mikado-cpt' ),
            'menu_name'			=> esc_html__( 'Sliders', 'mikado-cpt' ),
        );

        register_taxonomy($this->taxBase, array($this->base), array(
            'hierarchical'		=> true,
            'labels'			=> $labels,
            'show_ui'			=> true,
            'query_var'			=> true,
            'show_admin_column'	=> true,
            'rewrite'			=> array( 'slug' => 'slides-category' ),
        ));
    }
}