<?php

if(!function_exists('cortex_mikado_map_content_bottom_meta_fields')) {

	function cortex_mikado_map_content_bottom_meta_fields() {
		$content_bottom_meta_box = cortex_mikado_create_meta_box(
			array(
				'scope' => array('page', 'portfolio-item', 'post'),
				'title' => esc_html__('Content Bottom', 'cortex'),
				'name' => 'content_bottom_meta',
			)
		);

		cortex_mikado_create_meta_box_field(
			array(
				'name' => 'mkdf_enable_content_bottom_area_meta',
				'type' => 'selectblank',
				'default_value' => '',
				'label' => esc_html__('Enable Content Bottom Area', 'cortex'),
				'description' => esc_html__('This option will enable Content Bottom area on pages', 'cortex'),
				'parent' => $content_bottom_meta_box,
				'options' => array(
					'no' => 'No',
					'yes' => 'Yes'
				),
				'args' => array(
					'dependence' => true,
					'hide' => array(
						'' => '#mkdf_mkdf_show_content_bottom_meta_container',
						'no' => '#mkdf_mkdf_show_content_bottom_meta_container'
					),
					'show' => array(
						'yes' => '#mkdf_mkdf_show_content_bottom_meta_container'
					)
				)
			)
		);

		$show_content_bottom_meta_container = cortex_mikado_add_admin_container(
			array(
				'parent' => $content_bottom_meta_box,
				'name' => 'mkdf_show_content_bottom_meta_container',
				'hidden_property' => 'mkdf_enable_content_bottom_area_meta',
				'hidden_value' => '',
				'hidden_values' => array('','no')
			)
		);

		cortex_mikado_create_meta_box_field(
			array(
				'name' => 'mkdf_content_bottom_sidebar_custom_display_meta',
				'type' => 'selectblank',
				'default_value' => '',
				'label' => esc_html__('Sidebar to Display', 'cortex'),
				'description' => esc_html__('Choose a Content Bottom sidebar to display', 'cortex'),
				'options' => cortex_mikado_get_custom_sidebars(),
				'parent' => $show_content_bottom_meta_container
			)
		);

		cortex_mikado_create_meta_box_field(
			array(
				'type' => 'selectblank',
				'name' => 'mkdf_content_bottom_in_grid_meta',
				'default_value' => '',
				'label' => esc_html__('Display in Grid', 'cortex'),
				'description' => esc_html__('Enabling this option will place Content Bottom in grid', 'cortex'),
				'options' => array(
					'no' => 'No',
					'yes' => 'Yes'
				),
				'parent' => $show_content_bottom_meta_container
			)
		);

		cortex_mikado_create_meta_box_field(
			array(
				'type' => 'color',
				'name' => 'mkdf_content_bottom_background_color_meta',
				'default_value' => '',
				'label' => esc_html__('Background Color', 'cortex'),
				'description' => esc_html__('Choose a background color for Content Bottom area', 'cortex'),
				'parent' => $show_content_bottom_meta_container
			)
		);

	}
	
	add_action('cortex_mikado_meta_boxes_map', 'cortex_mikado_map_content_bottom_meta_fields');
}