<?php

if(!function_exists('cortex_mikado_register_full_screen_menu_nav')) {
    function cortex_mikado_register_full_screen_menu_nav() {
	    register_nav_menus(
		    array(
			    'popup-navigation' => esc_html__('Fullscreen Navigation', 'cortex')
		    )
	    );
    }

	add_action('after_setup_theme', 'cortex_mikado_register_full_screen_menu_nav');
}

if ( !function_exists('cortex_mikado_register_full_screen_menu_sidebars') ) {

	function cortex_mikado_register_full_screen_menu_sidebars() {

		register_sidebar(array(
			'name' => 'Fullscreen Menu Top',
			'id' => 'fullscreen_menu_above',
			'description' => 'This widget area is rendered above fullscreen menu',
			'before_widget' => '<div class="%2$s mkdf-fullscreen-menu-above-widget">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="mkdf-fullscreen-widget-title">',
			'after_title' => '</h4>'
		));

		register_sidebar(array(
			'name' => 'Fullscreen Menu Bottom',
			'id' => 'fullscreen_menu_below',
			'description' => 'This widget area is rendered in the bottom of the fullscreen menu',
			'before_widget' => '<div class="%2$s mkdf-fullscreen-menu-below-widget">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="mkdf-fullscreen-widget-title">',
			'after_title' => '</h4>'
		));

	}

	add_action('widgets_init', 'cortex_mikado_register_full_screen_menu_sidebars');

}

if(!function_exists('cortex_mikado_fullscreen_menu_body_class')) {
	/**
	 * Function that adds body classes for different full screen menu types
	 *
	 * @param $classes array original array of body classes
	 *
	 * @return array modified array of classes
	 */
	function cortex_mikado_fullscreen_menu_body_class($classes) {

		if ( is_active_widget( false, false, 'mkdf_full_screen_menu_opener' )  || cortex_mikado_get_meta_field_intersect('header_type', cortex_mikado_get_page_id()) == 'header-full-screen'  ) {

			$classes[] = 'mkdf-' . cortex_mikado_options()->getOptionValue('fullscreen_menu_animation_style');

		}

		return $classes;
	}

	add_filter('body_class', 'cortex_mikado_fullscreen_menu_body_class');
}

if ( !function_exists('cortex_mikado_get_full_screen_menu') ) {
	/**
	 * Loads fullscreen menu HTML template
	 */
	function cortex_mikado_get_full_screen_menu() {

		if ( is_active_widget( false, false, 'mkdf_full_screen_menu_opener' ) || cortex_mikado_get_meta_field_intersect('header_type', cortex_mikado_get_page_id()) == 'header-full-screen'  ) {

			$parameters = array(
				'fullscreen_menu_in_grid' => cortex_mikado_options()->getOptionValue('fullscreen_in_grid') === 'yes' ? true : false
			);

			cortex_mikado_get_module_template_part('templates/fullscreen-menu', 'fullscreenmenu', '', $parameters);

		}

	}

}

if ( !function_exists('cortex_mikado_get_full_screen_menu_navigation') ) {
	/**
	 * Loads fullscreen menu navigation HTML template
	 */
	function cortex_mikado_get_full_screen_menu_navigation() {

		cortex_mikado_get_module_template_part('templates/parts/navigation', 'fullscreenmenu');

	}

}