<?php

class CortexMikadoRawHTMLWidget extends CortexMikadoWidget {
    public function __construct() {
        parent::__construct(
            'mkdf_raw_html_widget',
            esc_html__( 'Mikado Raw HTML Widget', 'cortex' ),
            array( 'description' => esc_html__( 'Add raw HTML holder to widget areas', 'cortex' ) )
        );

        $this->setParams();
    }

    protected function setParams() {
        $this->params = array(
            array(
                'type'  => 'textfield',
                'name'  => 'extra_class',
                'title' => esc_html__( 'Extra Class Name', 'cortex' )
            ),
            array(
                'type'  => 'textfield',
                'name'  => 'widget_title',
                'title' => esc_html__( 'Widget Title', 'cortex' )
            ),
            array(
                'type'    => 'dropdown',
                'name'    => 'widget_grid',
                'title'   => esc_html__( 'Widget Grid', 'cortex' ),
                'options' => array(
                    ''     => esc_html__( 'Full Width', 'cortex' ),
                    'auto' => esc_html__( 'Auto', 'cortex' )
                )
            ),
            array(
                'type'  => 'textarea',
                'name'  => 'content',
                'title' => esc_html__( 'Content', 'cortex' )
            )
        );
    }

    public function widget( $args, $instance ) {
        $extra_class   = array();
        $extra_class[] = ! empty( $instance['extra_class'] ) ? $instance['extra_class'] : '';
        $extra_class[] = ! empty( $instance['widget_grid'] ) && $instance['widget_grid'] === 'auto' ? 'mkdf-grid-auto-width' : '';
        ?>

        <div class="widget mkdf-raw-html-widget <?php echo esc_attr( implode( ' ', $extra_class ) ); ?>">
            <?php


            if ( ! empty( $instance['widget_title'] ) ) {
                echo wp_kses_post( $args['before_title'] ) . esc_html( $instance['widget_title'] ) . wp_kses_post( $args['after_title'] );
            }
            if ( ! empty( $instance['content'] ) ) {
				echo cortex_mikado_get_module_part( $instance['content'] );
            }
            ?>
        </div>
        <?php
    }
}