<?php
/**
 * Single Product Meta
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

global $post, $product;

$cat_count = sizeof( get_the_terms( $post->ID, 'product_cat' ) );
$tag_count = sizeof( get_the_terms( $post->ID, 'product_tag' ) );

?>
<div class="product_meta">

    <?php do_action( 'woocommerce_product_meta_start' ); ?>

    <h6 class="mkdf-product-meta-title"><?php esc_html_e('Info','cortex');?></h6>

    <?php if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) { ?>

        <span class="sku_wrapper"><span class="mkdf-info-meta-title"><?php esc_html_e( 'SKU:', 'cortex' ); ?></span><span class="sku mkdf-info-meta-content"><?php echo cortex_mikado_get_module_part ( $sku = $product->get_sku() ) ? $sku : esc_html_e( 'N/A', 'cortex' ); ?></span></span>

    <?php } ?>

    <?php
		print wc_get_product_category_list( $product->get_id(), '<span class="mkdf-product-meta-separator">, </span>', '<span class="posted_in"><span class="mkdf-info-meta-title">' . _n( 'Category:', 'Categories:', count( $product->get_category_ids() ), 'cortex' ) . '</span><span class="mkdf-info-meta-content">', '</span></span>');
		print wc_get_product_tag_list( $product->get_id(), '<span class="mkdf-product-meta-separator">, </span>', '<span class="tagged_as"><span class="mkdf-info-meta-title">' . _n( 'Tag:', 'Tags:', count( $product->get_tag_ids() ), 'cortex' ) . '</span><span class="mkdf-info-meta-content">', '</span></span>');
	?>

    <?php do_action( 'woocommerce_product_meta_end' ); ?>

</div>